#include "msx.h"
#include <stdio.h>
#include <string.h>

void gotoxy(char x, char y) __naked {

	/*
		POSIT (00C6H)		*1
		Function:	moves the cursor
		Input:	H for the X-coordinate of the cursor, L for the Y-coordinate
		Output:	none
		Registers:	AF
	*/

  __asm
  	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

  	push af	        ; body
  	push hl
    ld h,4(ix)
    ld l,5(ix)
    call 0x00C6
    pop hl
    pop af

	pop	ix           ;epilogue
	ret

  __endasm;
}

void cls() {
  putchar(0x1b);
  putchar(0x45);
}

char joystick(char n) __naked {
	/*
		GTSTCK (00D5H)		*1
		Function:	returns the joystick status
		Input:	A for the joystick number to be tested
		Output:	A for the joystick direction
		Registers:	all
	*/
    __asm
  	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

	push af         ; body
    ld a,4(ix)
    call 0x00d5
    ld l,a
    pop af

	pop	ix          ; epilogue
	ret
	__endasm;
}

char joytrig(char n) __naked {

	/*
		GTTRIG (00D8H)		*1
		Function:	returns the trigger button status
		Input:	A for the trigger button number to be tested
		Output:	When A is 0, the trigger button is not being pressed.
		When A is FFH, the trigger button is being pressed.
		Registers:	AF
	*/

	__asm
  	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

	push af         ; body
    ld a,4(ix)
    call 0x00d8
    ld h,#0x00
    ld l,a
    pop af

    pop	ix          ; epilogue
	ret
  __endasm;
}

char peek(unsigned int address) __naked {
  __asm
  	push	ix  	; prologue
  	ld	ix,#0
	add	ix,sp

	ld l,4(ix)      ; body
    ld h,5(ix)
    ld l,(hl)
    ld h,#0x00

    pop	ix          ; epilogue
	ret
    __endasm;
}

int peek_word(unsigned int address) {
  return
    ((int)peek(address)&0xff) |
    (peek(address+1)<<8) ;
}

void poke(unsigned int address, char value) __naked {
  __asm
  	push	ix  	; prologue
  	ld	ix,#0
	add	ix,sp

  	push af         ; body
    ld l,4(ix)
    ld h,5(ix)
    ld a,6(ix)
    ld (hl),a
    pop af

    pop	ix          ; epilogue
	ret
  __endasm;
}

void poke_word(unsigned int address, int value){
  poke(address,value&0xff);
  poke(address+1, value&0xff00 >> 8);
}

void exit(void) { while(1); }

char is_ctrl_break() __naked {
	/*
		BREAKX (00B7H)		*1
		Function:	tests Ctrl-STOP key. In this routine, interrupts are
		inhibited.
		Input:	none
		Output:	the CY flag is set when pressed
		Registers:	AF
	*/
	__asm
	push	ix  	; prologue
	ld	ix,#0
	add	ix,sp

	                ; body
	call 0x00B7     ; BREAKX
	jr c, $1
	ld l, #0x00
	jr $2
$1:  
	ld l, #0x01
$2:  
	pop	ix          ; epilogue
	ret
	__endasm;
}
